/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.validation;

import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingFunction;
import com.floragunn.codova.validation.errors.FileDoesNotExist;
import com.floragunn.codova.validation.errors.ValidationError;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableResolvers {
    private static final Logger log = LoggerFactory.getLogger(VariableResolvers.class);
    public static final ValidatingFunction<String, Object> FILE = new ValidatingFunction<String, Object>(){

        @Override
        public Object apply(String fileName) throws ConfigValidationException {
            try {
                return Files.asCharSource((File)new File(fileName), (Charset)Charsets.UTF_8).read();
            }
            catch (FileNotFoundException e) {
                log.debug("File not found: {}", (Object)fileName, (Object)e);
                throw new ConfigValidationException(new FileDoesNotExist(null, new File(fileName)).cause(e));
            }
            catch (IOException e) {
                log.warn("Exception while reading {}", (Object)fileName, (Object)e);
                throw new ConfigValidationException(new ValidationError(null, "Error while reading file: " + e).cause(e));
            }
            catch (AccessControlException e) {
                log.warn("AccessControlException while reading {}", (Object)fileName, (Object)e);
                if (e.toString().contains("java.io.FilePermission")) {
                    throw new ConfigValidationException(new ValidationError(null, "The current Java security policy does not allow accessing the file " + fileName).cause(e));
                }
                throw new ConfigValidationException(new ValidationError(null, "Error while reading file: " + e).cause(e));
            }
        }
    };
    public static final ValidatingFunction<String, Object> FILE_PRIVILEGED = new ValidatingFunction<String, Object>(){

        @Override
        public Object apply(final String fileName) throws ConfigValidationException, Exception {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws ConfigValidationException, Exception {
                        return FILE.apply(fileName);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                if (e.getCause() instanceof Exception) {
                    throw (Exception)e.getCause();
                }
                if (e.getCause() instanceof Error) {
                    throw (Error)e.getCause();
                }
                throw new RuntimeException(e);
            }
        }
    };
    public static final ValidatingFunction<String, Object> ENV = new ValidatingFunction<String, Object>(){

        @Override
        public String apply(String name) {
            return System.getenv(name);
        }
    };
    public static final VariableResolvers ALL_PRIVILEGED = new VariableResolvers().with("file", FILE_PRIVILEGED).with("env", ENV);
    public static final VariableResolvers ALL = new VariableResolvers().with("file", FILE).with("env", ENV);
    private final Map<String, ValidatingFunction<String, Object>> map = new HashMap<String, ValidatingFunction<String, Object>>();

    public VariableResolvers with(String name, ValidatingFunction<String, Object> function) {
        VariableResolvers result = new VariableResolvers();
        result.map.putAll(this.map);
        result.map.put(name, function);
        return result;
    }

    public Map<String, ValidatingFunction<String, Object>> toMap() {
        return Collections.unmodifiableMap(this.map);
    }
}

